﻿using System;
using System.Collections.Generic;
using System.Text;

namespace DeX_Demo_Jun21
{
    public class XportBase
    {
       
        /// <summary>
        /// All records have an external id
        /// </summary>
        public Guid ExternalID;
        /// <summary>
        /// The MIS ID will be a GUID and not an int
        /// </summary>
        public string id { get { return ExternalID.ToString(); } }

        public static string nDateToString(Nullable<DateTime> d)
        {
            StringBuilder b = new StringBuilder();
            if (d == null)
            {
                b.Append("null");
            }
            else
            {
                b.Append(d.Value.Year);
                b.Append("-");
                if (d.Value.Month < 10)
                {
                    b.Append("0");
                }
                b.Append(d.Value.Month);
                b.Append("-");
                if (d.Value.Day < 10)
                {
                    b.Append("0");
                }
                b.Append(d.Value.Day);
            }
            return b.ToString();
        }

        public static string XFormat(string name, string value)
        {
            string rc = "";
            if (value != null)
            {
                rc = value;
            }
            // string format = "  <{0}>{1}<{/0}>";
            rc = rc.Replace("&", "&amp;");
            rc = rc.Replace(">", "&gt;");
            rc = rc.Replace("<", "&lt;");
            rc = rc.Replace("'", "&apos;");
            rc = rc.Replace("\"", "&quot;");
            return "        <" + name + ">" + rc + "</" + name + ">";
        }

    }
    public class Telephone : XportBase
    {
        public string main;
        public string location;
        public string telephone;
        public string ToXML()
        {
            StringBuilder b = new StringBuilder();
            b.AppendLine("          <pupiltelephone>");
            b.AppendLine("    "+XFormat("location", location));
            b.AppendLine("    " + XFormat("telephone", telephone));
            b.AppendLine("    " + XFormat("main", main));
            b.AppendLine("          </pupiltelephone>");
            return b.ToString(); 
        }
    }
    public class ContactLinks
    {
        public Contact contact;
        public string Priority;
    }
    public class Contact : XportBase
    {
        public string email;
        public string mobile;
        public string telephone;
        /// <summary>
        /// ContactBasics
        /// </summary>
        public string lastname;  
        /// <summary>
        /// Contact Basics
        /// </summary>
        public string firstname;
        /// <summary>
        /// Please note 1 character gender required.
        /// Contact basics lookup
        /// </summary>
        public string Gender;
        public string Title;
        public string salutation;
        public string workemail;
        #region Contact Address
        /// <summary>
        /// House number for Contact address
        /// </summary>
        public string HouseNumber;
        /// <summary>
        /// House name  for Contact address
        /// </summary>
        public string HouseName;
        /// <summary>
        /// Appartment  for Contact address
        /// </summary>
        public string Apartment;
        /// <summary>
        /// Street  for Contact address
        /// </summary>
        public string Street;
        /// <summary>
        /// District  for Contact address
        /// </summary>
        public string District;
        /// <summary>
        /// Town  for Contact address
        /// </summary>
        public string Town;
        /// <summary>
        /// Returned as County  for Contact address
        /// </summary>
        public string AdministrativeArea;
        /// <summary>
        /// Post code For Contact address
        /// </summary>
        public string Postcode;
        #endregion
        public string ToXML(string Priority)
        {
            string spacing = "      ";
            StringBuilder b = new StringBuilder();
            b.AppendLine("          <contact>");
            b.AppendLine(spacing + XFormat("id", id));
            b.AppendLine(spacing + XFormat("email", email));
            b.AppendLine(spacing + XFormat("mobile", mobile));
            b.AppendLine(spacing + XFormat("telephone", telephone));
            b.AppendLine(spacing + XFormat("lastname", lastname));
            b.AppendLine(spacing + XFormat("firstname", firstname));
            #region Contact Address
            b.AppendLine(spacing + XFormat("HouseNumber", HouseNumber));
            b.AppendLine(spacing + XFormat("HouseName", HouseName));
            b.AppendLine(spacing + XFormat("Apartment", Apartment));
            b.AppendLine(spacing + XFormat("Street", Street));
            b.AppendLine(spacing + XFormat("District", District));
            b.AppendLine(spacing + XFormat("Town", Town));
            b.AppendLine(spacing + XFormat("County", AdministrativeArea));
            b.AppendLine(spacing + XFormat("Postcode", Postcode));
            #endregion
            b.AppendLine(spacing + XFormat("workemail", workemail));
            b.AppendLine(spacing + XFormat("salutation", salutation));
            b.AppendLine(spacing + XFormat("Priority", Priority));

            b.AppendLine("          </contact>");

            return b.ToString();
        }
    }
    public class StudentRecord : XportBase
    {
        #region Helper functions
        public string toXML()
        {
            StringBuilder b = new StringBuilder();
            b.AppendLine("  <Record>");
            b.AppendLine(XFormat("RecordType", "PUPIL"));
            b.AppendLine(XFormat("AdmissionNumber", AdmissionNumber));
            b.AppendLine(XFormat("ChosenName", ChosenName));
            b.AppendLine(XFormat("DateOfBirth", nDateToString(DateOfBirth)));
            b.AppendLine(XFormat("Diet", Diet));
            b.AppendLine(XFormat("free_meal", free_meal));
            b.AppendLine(XFormat("Gender", Gender));
            b.AppendLine(XFormat("group_code", group_code));
            #region Pupil Address
            b.AppendLine(XFormat("HouseNumber", HouseNumber));
            b.AppendLine(XFormat("HouseName", HouseName));
            b.AppendLine(XFormat("Apartment", Apartment));
            b.AppendLine(XFormat("Street", Street));
            b.AppendLine(XFormat("District", District));
            b.AppendLine(XFormat("Town", Town));
            b.AppendLine(XFormat("County", AdministrativeArea));
            b.AppendLine(XFormat("Postcode", Postcode));
            #endregion
            b.AppendLine(XFormat("RegGroup", CurrentPrimaryClass));
            b.AppendLine(XFormat("Surname", Surname));
            b.AppendLine(XFormat("UPN", UPN));
            b.AppendLine(XFormat("Meal", Meal));
            b.AppendLine("        <Telephones>");
            if (telephones != null)
            {
                foreach (Telephone t in telephones)
                {
                    b.AppendLine(t.ToXML());
                }
            }
            b.AppendLine("        </Telephones>");
            b.AppendLine("        <ContactList>");
            if (contacts != null)
            {
                foreach (ContactLinks l in  contacts)
                {
                    b.AppendLine(l.contact.ToXML(l.Priority));
                }
            }
            b.AppendLine("        </ContactList>");

            b.AppendLine(XFormat("email_address", email_address));
            b.AppendLine(XFormat("Weekly_meal_pattern", Weekly_meal_pattern));
            // Duplicated for some reason
            b.AppendLine(XFormat("ID", id));
            b.AppendLine("  </Record>");


            return b.ToString();
        }
        #endregion
        #region statics and constants
        /// <summary>
        /// All records are of type PUPIL
        /// </summary>
        public string RecordType { get { return "PUPIL"; } }
        /// <summary>
        /// Used instead of assuming preferred surname is filled
        /// </summary>
        public string Surname { get { return string.IsNullOrEmpty(PreferredSurname) ? LegalSurname : PreferredSurname; } }
        /// <summary>
        /// Used instead of assuming preferred forename is filled.
        /// </summary>
        public string ChosenName { get { return string.IsNullOrEmpty(PreferredForename) ? LegalForename : PreferredForename; } }
        /// <summary>
        /// returns the NC year of the pupil
        /// </summary>
        public string group_code { get { return CurriculumYear; } }
        #endregion
        #region Internal Properties
        public string PreferredSurname;
        public string PreferredForename;
        public string LegalSurname;
        public string LegalForename;
        #endregion
        #region Properties
        /// <summary>
        /// Learner admission number
        /// </summary>
        public string AdmissionNumber;
        /// <summary>
        /// Unique Pupil Number
        /// </summary>
        public string UPN;
        /// <summary>
        /// Learner Date of birth
        /// </summary>
        public Nullable<DateTime> DateOfBirth;
        /// <summary>
        /// T if there is a current FSM entitlement
        /// </summary>
        public string free_meal;
        /// <summary>
        /// List of dietary needs
        /// <Diet>Artificial colouring allergy, Gluten free, No dairy produce, No nuts of any type/quantity, No pork, Seafood allergy, Vegetarian</Diet>
        /// </summary>
        public string Diet;
        /// <summary>
        /// Learner Gender - NB - want single character which theoretically may be ambiguous
        /// </summary>
        public string Gender;
        public string CurrentPrimaryClass;
        public string CurriculumYear;
        public Nullable<DateTime> free_meal_start;
        public Nullable<DateTime> free_meal_end;
        #region Pupil Address
        /// <summary>
        /// House number for pupil address
        /// </summary>
        public string HouseNumber;
        /// <summary>
        /// House name  for pupil address
        /// </summary>
        public string HouseName;
        /// <summary>
        /// Appartment  for pupil address
        /// </summary>
        public string Apartment;
        /// <summary>
        /// Street  for pupil address
        /// </summary>
        public string Street;
        /// <summary>
        /// District  for pupil address
        /// </summary>
        public string District;
        /// <summary>
        /// Town  for pupil address
        /// </summary>
        public string Town;
        /// <summary>
        /// Returned as County  for pupil address
        /// </summary>
        public string AdministrativeArea;
        /// <summary>
        /// Post code For pupil address
        /// </summary>
        public string Postcode;
        #endregion
        /// <summary>
        /// Returns T if Universal Credit Transitional Protection is set
        /// </summary>
        public string FSMTransitionalProtection;
        /// <summary>
        /// States the default for the child's meal arrangements
        /// </summary>
        public string Meal;
        /// <summary>
        /// Parental salutation for letters home
        /// e.g Mr and Mrs Holmes
        /// </summary>
        public string Salutation;
        public List<Telephone> telephones;
        public List<ContactLinks> contacts;
        public string email_address;
        public string Weekly_meal_pattern;

        #endregion
    } 
}
   